<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */         

    /**
     * Classe statica che contiene metodi di ausilio a varie parti estetiche del sito
     *
     * @author andrea
     */
    class UtilTemplate {
        
        static function stampaRoot($configurazioneAspetto) {
            echo"<link rel=\"shortcut icon\" href=\"{$configurazioneAspetto["favicon"]}\" />
                <link href=\"{$configurazioneAspetto["linkFont"]}\" rel=\"stylesheet\" type=\"text/css\">
                <style type=\"text/css\">
                :root {
                --input-padding-x: .75rem;
                --input-padding-y: .75rem;
                --primary: {$configurazioneAspetto["colorePrimario"]};
                --primary-over: {$configurazioneAspetto["colorePrimarioHover"]};
                --primary-active: {$configurazioneAspetto["colorePrimarioActive"]};
                --secondary: {$configurazioneAspetto["coloreSecondario"]};
                --secondary-over: {$configurazioneAspetto["coloreSecondarioHover"]};
                --secondary-active: {$configurazioneAspetto["coloreSecondarioActive"]};
                --success: {$configurazioneAspetto["coloreSuccess"]};
                --success-over: {$configurazioneAspetto["coloreSuccessHover"]};
                --success-active: {$configurazioneAspetto["coloreSuccessHover"]};
                --info: {$configurazioneAspetto["coloreInfo"]};
                --info-over: {$configurazioneAspetto["coloreInfoHover"]};
                --info-active: {$configurazioneAspetto["coloreInfoActive"]};
                --warning: {$configurazioneAspetto["coloreWarning"]};
                --warning-over: {$configurazioneAspetto["coloreWarningHover"]};
                --warning-active: {$configurazioneAspetto["coloreWarningActive"]};
                --danger: {$configurazioneAspetto["coloreDanger"]};
                --danger-over: {$configurazioneAspetto["coloreDangerHover"]};
                --danger-active: {$configurazioneAspetto["coloreDangerActive"]};
                --light: {$configurazioneAspetto["coloreLight"]};
                --light-over: {$configurazioneAspetto["coloreLightHover"]};
                --light-active: {$configurazioneAspetto["coloreLightActive"]};
                --dark: {$configurazioneAspetto["coloreDark"]};
                --dark-over: {$configurazioneAspetto["coloreDarkHover"]};
                --dark-active: {$configurazioneAspetto["coloreDarkActive"]};
                --breakpoint-xs: 0;
                --breakpoint-sm: {$configurazioneAspetto["breakingPointsXs"]};
                --breakpoint-md: {$configurazioneAspetto["breakingPointsMd"]};
                --breakpoint-lg: {$configurazioneAspetto["breakingPointsLg"]};
                --breakpoint-xl: {$configurazioneAspetto["breakingPointsXl"]};
                --logo-h:{$configurazioneAspetto["altezzaLogo"]};
                --logo-w:{$configurazioneAspetto["larghezzaLogo"]};
                --logo-h-xl:{$configurazioneAspetto["altezzaLogoXl"]};
                --logo-w-xl:{$configurazioneAspetto["larghezzaLogoXl"]};
            }
            body{ 
                {$configurazioneAspetto["fontTesti"]}
            }
            h1, h2, h3, h4, h5, h6, 
            .h1, .h2, .h3, .h4, .h5, .h6 { 
                {$configurazioneAspetto["fontIntestazioni"]}
            }
            </style>";            
        }
        
        /* funzione per creare le breadcrumb */
        static function creaBreadCrumb($db,$articolo,$impostazioni ) {
            $lingua             = $GLOBALS["lingua"];
            
            if($lingua==$impostazioni["linguaSito"]) {
                $urlHomePage = $impostazioni["urlSito"];
            }
            else {
                $arrayColonneHomePage      = array("italiano"=>"homePage","inglese"=>"homePageEn","tedesco"=>"homePageDe","francese"=>"homePageFr","spagnolo"=>"homePageEs");
                $colonnaHomePage           = $arrayColonneHomePage[$lingua];
                $datiHomeLinguaSelezionata = $db->leggiSingolaRiga("geecB_contenuti",$impostazioni[$colonnaHomePage]);
                $urlHomePage               = GeneratoreUrl::creaUrlContenuto($datiHomeLinguaSelezionata, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
            }
            
            if($articolo["tipo"]!="articolo") {
                echo"<nav>
                        <ol class=\"breadcrumb rounded-0 mt-3\">
                            <li class=\"breadcrumb-item\" ><a href=\"{$urlHomePage}\">Home</a></li>
                            <li class=\"breadcrumb-item active\">{$articolo["titolo"]}</li>
                        </ol>
                  </nav>";	          
            }
            else {
                if($articolo["categoria"]>0) {
                    $query = "SELECT * FROM geec_categorie WHERE id={$articolo["categoria"]}";
                    $risQuery = $db->eseguiQueryLettura($query);
                    $categoria = $risQuery->fetch_assoc();
                    $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                    $codiceCategoriaMadre = "";
                    if($categoria["categoriaMadre"]>0) {
                        $categoriaMadre      = $db->leggiSingolaRiga("geec_categorie",$categoria["categoriaMadre"]);
                        $linkCategoriaMadre  = GeneratoreUrl::creaUrlCategoria($categoriaMadre,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                        $codiceCategoriaMadre = "<li class=\"breadcrumb-item\"><a href=\"$linkCategoriaMadre\">{$categoriaMadre["nome"]}</a></li>";
                    }
                    echo"<nav>
                        <ol class=\"breadcrumb rounded-0 mt-3\">
                            <li class=\"breadcrumb-item\" ><a href=\"{$urlHomePage}\">Home</a></li>
                            $codiceCategoriaMadre
                            <li class=\"breadcrumb-item\" ><a href=\"$linkCategoria\">{$categoria["nome"]}</a></li>
                            <li class=\"breadcrumb-item active\">{$articolo["titolo"]}</li>
                        </ol>
                  </nav>";
                }
                else {
                    echo"<nav>
                            <ol class=\"breadcrumb rounded-0 mt-3\">
                                <li class=\"breadcrumb-item\" ><a href=\"{$urlHomePage}\">Home</a></li>
                                <li class=\"breadcrumb-item active\">{$articolo["titolo"]}</li>
                            </ol>
                      </nav>";
                }
            }
        }
        
        static function stampaComponenti($geecomDb,$gestoreJavascript,$impostazioni,$idContenuto, $gestoreTraduzioni,$linguaCorrente,$tipoElemento = "contenuto", $stampaSezione = "si") {
            $queryComponentiDaMostrare = "SELECT c.nome,posizione,tipo,testo,ch.script,idElemento,idSezione,classeSezione,animazione,altreOpzioni,aTuttaLarghezza,coloreSfondo,immagineSfondo,videoSfondo FROM geecB_composizionePagine AS ch "
                            . "JOIN geecB_componenti AS c ON ch.idComponente =c.id "
                            . "WHERE idPagina={$idContenuto} AND ch.tipoElemento='$tipoElemento' AND ch.nascosto NOT LIKE 'si' "
                            . "ORDER BY posizione ASC";
            $risComponentiHome = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
            
            while($componente = $risComponentiHome->fetch_assoc()) {
                UtilTemplate::stampaSingoloComponente($geecomDb,$gestoreJavascript,$impostazioni,$componente,$gestoreTraduzioni,$linguaCorrente,$stampaSezione);
            }
        }

        static function stampaSingoloComponente($geecomDb,$gestoreJavascript,$impostazioni,$componente,$gestoreTraduzioni,$linguaCorrente,$stampaSezione="si") {
            if($componente["nome"]=="Intestazione") {
                stampaIntestazione($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Testo") {
                stampaTesto($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Html") {
                stampaCodiceHtml($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Immagine") {
                stampaImmagine($impostazioni,$componente,$stampaSezione);
            }
            else if($componente["nome"]=="Audio") {
                stampaAudio($impostazioni,$componente,$stampaSezione);
            }
            else if($componente["nome"]=="Video") {
                $visualizzatoreComponente = new VisualizzatoreVideo($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Includi codice") {
                includiCodice($componente);
            }
            else if($componente["nome"]=="Blog") {
                $configurazioneAspetto = $GLOBALS["configurazioneAspetto"];
                include "template/include/creaBlog.php";
            }
            else if($componente["nome"]=="Slider") {
                $visualizzatoreComponente = new VisualizzatoreSlider($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->setSonoPresentiSlider(true);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Colonne in evidenza") {
                $visualizzatoreComponente = new VisualizzatoreColonneInEvidenza($geecomDb,$stampaSezione);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Articoli dal blog") {
                $visualizzatoreComponente = new VisualizzatoreArticoliDalBlog($geecomDb);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Portfolio") {
                $visualizzatoreComponente = new VisualizzatorePortfolio($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Inviti all'azione") {
                $visualizzatoreComponente = new VisualizzatoreInvitoAzione($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Form") {
                $visualizzatoreComponente = new VisualizzatoreForm($geecomDb);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Visualizzatore galleria") {
                $visualizzatoreComponente = new VisualizzatoreGalleria($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Griglia contenuti") {
                $visualizzatoreComponente = new VisualizzatoreGrigliaImmagini($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Metro slider") {
                $visualizzatoreComponente = new VisualizzatoreMetroSlider($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->setSonoPresentiSlider(true);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Lista") {
                $visualizzatoreComponente = new VisualizzatoreLista($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Sezione sdoppiata") {
                $visualizzatoreComponente = new VisualizzatoreSezioneSdoppiata($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Sezione a due colonne") {
                $visualizzatoreComponente = new VisualizzatoreSezioneADueColonne($geecomDb);
                $visualizzatoreComponente->setImpostazioni($impostazioni);
                $visualizzatoreComponente->setGestoreJavascript($gestoreJavascript);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Sezione a tre colonne") {
                $visualizzatoreComponente = new VisualizzatoreSezioneATreColonne($geecomDb);
                $visualizzatoreComponente->setImpostazioni($impostazioni);
                $visualizzatoreComponente->setGestoreJavascript($gestoreJavascript);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Sezione a quattro colonne") {
                $visualizzatoreComponente = new VisualizzatoreSezioneAQuattroColonne($geecomDb);
                $visualizzatoreComponente->setImpostazioni($impostazioni);
                $visualizzatoreComponente->setGestoreJavascript($gestoreJavascript);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Confronto immagini") {
                $visualizzatoreComponente = new VisualizzatoreConfrontoImmagini($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Tabella") {
                $visualizzatoreComponente = new VisualizzatoreTabella($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiLinkJavascript("<script src=\"https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js\"></script>");
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Tabella prezzi") {
                $visualizzatoreComponente = new VisualizzatoreTabellaPrezzi($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Singola risorsa") {
                $visualizzatoreComponente = new VisualizzatoreRisorsaSingola($geecomDb);
                $visualizzatoreComponente->setLingua($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Risorse") {
                $visualizzatoreComponente = new VisualizzatoreRisorse($geecomDb);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Banner") {
                $visualizzatoreComponente = new VisualizzatoreBanner($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Profili") {
                $visualizzatoreComponente = new VisualizzatoreProfili($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Testimonianze") {
                $visualizzatoreComponente = new VisualizzatoreTestimonianze($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->setSonoPresentiSlider(true);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Mappa") {
                $visualizzatoreComponente = new VisualizzatoreMappa($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Contatore") {
                $visualizzatoreComponente = new VisualizzatoreContatore($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Contenuti girevoli") {
                $visualizzatoreComponente = new VisualizzatoreContenutiGirevoli($geecomDb);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Prodotti dal negozio") {
                $visualizzatoreComponente = new VisualizzatoreProdottiDalNegozio($geecomDb);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
                $gestoreJavascript->setSonoPresentiSlider(true);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Modulo login/registrati") {
                $visualizzatoreComponente = new VisualizzatoreModuloLogin($geecomDb);
                $visualizzatoreComponente->setGestoreTraduzioni($gestoreTraduzioni);
                $visualizzatoreComponente->setLinguaCorrente($linguaCorrente);
                $visualizzatoreComponente->stampaHtmlComponente($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Profili social") {
                stampaProfiliSocial($componente,$stampaSezione);
            }
            else if($componente["nome"]=="Separatore") {
                stampaSeparatore($componente,$stampaSezione);
            }
            else {
                include $componente["script"];
            }
        }
        
        /*
         * Questa funzione è utilizzata da tutti i temi che riguardano il portfolio nei vari aspetti di Geecom
         * 
         * $geecomDb   istanza del database
         * $contenuto  elemento del portfolio
         * $impostazioni le impostazioni di Geecom
         */
        static function stampaElementiCorrelatiPortfolio($geecomDb,$contenuto,$impostazioni) {
            $portfolio  = $geecomDb->leggiSingolaRiga("geec_portfolio",$contenuto["contenutoRiferimento"]);
            $classeBase = ($portfolio["mostraNomiElementi"]=="si") ? $portfolio["classeElementi"]." labelVisibile" : $portfolio["classeElementi"];
            
            $query = "SELECT * FROM geecB_contenuti WHERE
                        contenutoRiferimento={$contenuto["contenutoRiferimento"]}
                        AND tipo LIKE 'elementoPortfolio' 
                        AND id != {$contenuto["id"]}
                        LIMIT 4";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            while($contenutoTrovato = $risQuery->fetch_assoc()) {
                $linkElemento = GeneratoreUrl::creaUrlContenuto($contenutoTrovato, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                
                echo"<div class=\"$classeBase col-md-6 col-lg-3\">
                        <div class=\"portfolio\">
                            <div class=\"portfolio-wrapper mb-4\">
                                <a href=\"$linkElemento\">
                                    <div class=\"background-image aspect-ratio-1-1\" style=\"background: url('{$contenutoTrovato["foto"]}')\"></div>
                                    <div class=\"label\">
                                        <div class=\"label-text\">
                                            <div class=\"text-title\">{$contenutoTrovato["titolo"]}</div>
                                        </div>
                                        <div class=\"label-bg\"></div>
                                    </div>
                                </a>
                            </div>
                        </div>	
                    </div>";
            }
        }
        
        static function stampaFooter($geecomDb,$impostazioniFooter) {
            $classeColonna = UtilTemplate::calcolaClasseColonne($impostazioniFooter["numeroColonne"]);
            for($i=1 ;$i<=$impostazioniFooter["numeroColonne"]; $i++) {
                UtilTemplate::stampaColonnaFooter($geecomDb,$impostazioniFooter,$i,$classeColonna);
            }
        }
        
        static function stampaColonnaFooter($geecomDb,$impostazioniFooter,$numeroColonna,$classeColonna) {
            echo"<div class=\"$classeColonna {$impostazioniFooter["coloreTestiMenu"]}\">
                <h4>{$impostazioniFooter["titoloColonna$numeroColonna"]}</h4>
                    <ul class=\"list-group {$impostazioniFooter["coloreTestiMenu"]}\">";
                    $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu={$impostazioniFooter["colonna$numeroColonna"]} AND tipo NOT LIKE 'voce sottoMenu' ORDER BY posizione ASC";
                    $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);

                    while($voceMenu = $risVociMenu->fetch_assoc()) {
                        $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i> " : "";
                        if($voceMenu["tipo"]=="link immagine") {
                            echo"<li ><a href=\"{$voceMenu["link"]}\"><img src=\"{$voceMenu["immagine"]}\"></a></li>";
                        }
                        else {
                            echo"<li ><a href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]}</a></li>";
                        }
                    }
                echo"</ul>
                {$impostazioniFooter["testoAggiuntivoColonna$numeroColonna"]}
            </div>";
        }
        
        static function calcolaClasseColonne($numeroColonna) {
            if($numeroColonna==1) {
                return "col-12 mb-2";
            }
            elseif($numeroColonna==2) {
                return "col-sm-6 mb-4 mb-sm-2";
            }
            elseif($numeroColonna==3) {
                return "col-md-4 mb-4 mb-md-2";
            }
            elseif($numeroColonna==4) {
                return "col-sm-6 col-md-3 mb-4 mb-sm-2 mb-md-2";
            }
            else {
                return "";
            }
        }
        
        static function stampaScrollTop() {
            echo"<button onclick=\"topFunction()\" id=\"toTop\" title=\"Inizio\" class=\"\"><i class=\"fas fa-chevron-up\"></i></button>";
        }
    }